window.onload = function () {
    var tusouAPI = "https://detail.91jf.com/search/image?url="
    var regUrlExt = /^((https|http):\/\/.+\.(jpeg|jpg|png)).*$/i
    var searchTag = document.createElement('div')
    searchTag.innerHTML = '';
    searchTag.setAttribute('class', 'i-search-tag')
    searchTag.setAttribute('title', '戳我搜同款，下单更优惠')
    document.querySelector('body').appendChild(searchTag);


    //过滤图片
    function filterImg(img) {
        var result = false,
            imgEle = img,
            imgUrl = imgEle.getAttribute('src')
	    minWidth = 80,
            minHeight = 80,
            maxScale = 7 / 4,
            minScale = 4 / 7

        var imgWidth = imgEle.clientWidth,
            imgHeight = imgEle.clientHeight,
            imgScale = imgWidth / imgHeight
        // 获取图片宽度
        if (imgWidth >= minWidth && imgHeight >= minHeight && imgScale <= maxScale && imgScale >= minScale) {
            result = true
        }
        return result
    }

    function setSearchTag(target,src='') {
        if(src==''){
            src = target.getAttribute('src');
        }

        var imgPos = target.getBoundingClientRect();
        searchTag.style.top = imgPos.top + 5 + 'px'
        searchTag.style.left = imgPos.left + 5 + 'px'
        if (src.indexOf('//') == 0) {
            src = location.protocol + src
        }
        searchTag.setAttribute('data-src', src)
        if (regUrlExt.test(src)) {
			searchTag.style.position = 'fixed'
			searchTag.style.zIndex = '9999999999'
			searchTag.style.width = '40px'
			searchTag.style.height = '40px'
            		searchTag.style.display = 'block'
			searchTag.style.cursor = 'pointer'
			searchTag.style.background = 'url(https://www.91jf.com/view/public/images/91zh.png) no-repeat center/ 100%'
			// if(src.indexOf('fangzhifu')>-1){
			// 	searchTag.style.display = 'none'
			// }
        }
    }

    document.querySelector('body').addEventListener('mousemove', function (e) {

        var site = window.location.href;

        var target = e.target || e.srcElement;

        var src = '';
        if(site.indexOf('1688')>=0){

            if(target.className=='changhuo_pank'){
                var target_parent = target.parentElement;
                if(target_parent.className=='offer-img-box'){
                    target = target_parent.children[0];

                }
            }else if(target.className=='is-video-container'){

                var target_parent = target.parentElement;
                if(target_parent.className=='offer'){
                    var target_child = target_parent.children[1];
                    if(target_child.className=='offer-img'){
                        target = target_child.children[0];

                    }
                }
            }else if(target.className=='img'){
                var img = e.target.style.backgroundImage;
                src = img.replace(/url\("/g,'');
                src = src.replace(/"\)/g,'');

                setSearchTag(target,src);
                return;
            }

        }else if(site.indexOf('tmall')>=0){

            if(target.className=='ks-imagezoom-lens'){
                var target_parent = target.parentElement;
                if(target_parent.className=='ks-imagezoom-wrap'){
                    target = target_parent.children[0];

                }
            }

        }

        if (target.nodeName&&target.nodeName.toLowerCase() == 'img') {
            var imageStatus = filterImg(target)
            if (imageStatus) {
                setTimeout(function () {
                    setSearchTag(target,src);
                }, 100)
            }
        } else if (document.querySelector('.i-search-tag') && !target.classList.contains('i-search-tag')) {
            document.querySelector('.i-search-tag').style.display = 'none'
        }




    })

    document.querySelector('body').addEventListener('click', function (e) {
        var target = e.target || e.srcElement
        if (target.classList.contains('i-search-tag')) {
            e.stopPropagation()
            e.preventDefault()
            var src = target.getAttribute('data-src')
            if (regUrlExt.test(src)) {
                searchByImg(src)
            }
        }
    })

    window.addEventListener('scroll', function () {
        if (document.querySelector('.i-search-tag')) {
            document.querySelector('.i-search-tag').style.display = 'none'
        }
    })

    function searchByImg(srcUrl) {
        var src = handleUrl(srcUrl)
        if (src != null) {
            var url = tusouAPI + encodeURIComponent(src);
            //url = url + '&fromUrl=' + encodeURIComponent(window.location.href)
            window.open(url)
        }
    }

    // 针对一些特殊图片以及其他网址图片链接进行处理。
    function handleUrl(url) {
        var url = url
        var regExt = /^(https?:)?\/\/\S+\.alicdn.com.*\.(jpe?g|png).*/i;
        if (regExt.test(url)) {
            url = url.replace(/(_[0-9]+x[0-9]+\.jpg)|_\.webp/g, '')
        }
        if (url.indexOf('//') == 0) {
            url = location.protocol + url
        }
        var m = url.match(regUrlExt)
        if (m != null) {
            return m[1]
        }
        return null
    }

    const query = {
        text: ''
    };
    
};