/**
 * 右键
 */
(function () {
    var searchResult = "https://detail.91jf.com/search/image?url="

    function searchByImg(info, tab) {
        var src = handleUrl(info.srcUrl, tab)
        if (src != null) {
            var url = encodeURIComponent(src)
            url = searchResult + url;
            //url = url + '&web_source=' + encodeURIComponent(tab.url)
            chrome.tabs.create({
                "url": url
            })
        }
    }


    chrome.runtime.onMessage.addListener(function (request, sender, sendResponse) {
        if (request.type === 'search') {
            searchByImg(request, sender.tab)
            sendResponse({
                farewell: '搜索成功'
            })
        } else {
            sendResponse({})
        }
    })

    // chrome.contextMenus.create({
    //     "id": "my91ContextMenu", // 必须提供唯一的 id
    //     "title": "通过「91找货助手」搜索商品",
    //     "contexts": ["image"],
    //     // "onclick": searchByImg
    // })
    chrome.runtime.onInstalled.addListener(() => {
        chrome.contextMenus.create({
            id: "my91ContextMenu",
            title: "通过「91找货助手」搜索商品",
            contexts: ["image"]
        });
    });

    // 监听菜单项点击事件
    chrome.contextMenus.onClicked.addListener(function (info, tab) {
        if (info.menuItemId === "my91ContextMenu") {
            searchByImg(info, tab);
        }
    });

    // 针对一些特殊图片以及其他网址图片链接进行处理。
    var handleUrl = function (url, tab) {
        var _url = url
        var _regExt = /^(https?:)?\/\/\S+\.alicdn.com.*\.(jpe?g|png).*/i
        if (_regExt.test(_url)) {
            _url = _url.replace(/(_[0-9]+x[0-9]+\.jpg)|_\.webp/g, '')
        }
        if (_url.indexOf('//') == 0) {
            _url = location.protocol + _url
        }
        var m = _url.match(/^((https|http):\/\/.+\.(jpeg|jpg|png)).*$/i)
        if (m != null) {
            return m[1]
        }
        return null
    }
})();